<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Club extends Model 
{

    protected $table = 'clubs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'company_name', 'logo', 'location', 'grade');

    public function events()
    {
        return $this->hasMany('Event');
    }

}